document.addEventListener('DOMContentLoaded', () => {
  const outerOrbit = document.querySelector('.orbit-wrapper.outer');
  const innerOrbit = document.querySelector('.orbit-wrapper.inner');

  // Configuration for Outer Ring (5 items, balanced distribution ~72° spacing)
  // Rotating Counter-Clockwise
  const outerLogos = [
    { name: 'Bitcoin', src: 'https://cryptologos.cc/logos/bitcoin-btc-logo.svg?v=026', angle: 0 },
    { name: 'TRON', src: 'https://cryptologos.cc/logos/tron-trx-logo.svg?v=026', angle: 72 },
    { name: 'Monero', src: 'https://cryptologos.cc/logos/monero-xmr-logo.svg?v=026', angle: 144 },
    { name: 'Solana', src: 'https://cryptologos.cc/logos/solana-sol-logo.svg?v=026', angle: 216 },
    { name: 'Ethereum', src: 'https://cryptologos.cc/logos/ethereum-eth-logo.svg?v=026', angle: 288 },
  ];

  // Configuration for Inner Ring (3 items, balanced distribution 120° spacing)
  // Rotating Clockwise (Offset by 60° to sit between outer nodes)
  const innerLogos = [
    { name: 'USDC', src: 'https://cryptologos.cc/logos/usd-coin-usdc-logo.svg?v=026', angle: 60 },
    { name: 'Dogecoin', src: 'https://cryptologos.cc/logos/dogecoin-doge-logo.svg?v=026', angle: 180 },
    { name: 'Arbitrum', src: 'https://cryptologos.cc/logos/arbitrum-arb-logo.svg?v=026', angle: 300 },
  ];

  // Helper to create orbit item
  function createOrbitItem(logo, radius) {
    // 1. Container positioned on the ring
    const item = document.createElement('div');
    item.className = 'orbit-item';
    item.style.setProperty('--ang', `${logo.angle}deg`);
    item.style.setProperty('--rad', `${radius}px`);

    // 2. Counter-rotator (animates to oppose ring spin)
    const counterRotator = document.createElement('div');
    counterRotator.className = 'icon-counter-rotate';

    // 3. Icon Box (static counter-rotation for initial placement)
    const iconBox = document.createElement('div');
    iconBox.className = 'icon-box';
    
    // 4. Image
    const img = document.createElement('img');
    img.src = logo.src;
    img.alt = logo.name;

    // Assemble
    iconBox.appendChild(img);
    counterRotator.appendChild(iconBox);
    item.appendChild(counterRotator);
    
    return item;
  }

  // Populate Outer Ring
  outerLogos.forEach(logo => {
    outerOrbit.appendChild(createOrbitItem(logo, 120));
  });

  // Populate Inner Ring
  innerLogos.forEach(logo => {
    innerOrbit.appendChild(createOrbitItem(logo, 85));
  });

  // Dynamic Greeting Animation
  const greetings = ["Salut!", "Hello!", "Hola!", "Καλησπέρα!", "Buongiorno!"];
  let currentGreetingIndex = 0;
  const greetingElement = document.getElementById('greeting');

  if (greetingElement) {
    setInterval(() => {
      // 1. Fade out
      greetingElement.classList.add('fade-out');

      // 2. Wait for fade transition (500ms), then swap text and fade in
      setTimeout(() => {
        currentGreetingIndex = (currentGreetingIndex + 1) % greetings.length;
        greetingElement.textContent = greetings[currentGreetingIndex];
        greetingElement.classList.remove('fade-out');
      }, 500); // Matches CSS transition duration
    }, 2000); // Cycle every 2 seconds
  }
});
