document.addEventListener('DOMContentLoaded', () => {
    // Select independent tracks
    const graphicSlides = document.querySelectorAll('.graphic-slide');
    const textSlides = document.querySelectorAll('.text-slide');
    const dots = document.querySelectorAll('.dot');
    
    let currentIndex = 0;
    const intervalTime = 5000; // 5 seconds
    let slideInterval;

    // Function to show a specific slide index across all tracks
    function showSlide(index) {
        // Wrap around logic
        if (index < 0) index = graphicSlides.length - 1;
        if (index >= graphicSlides.length) index = 0;

        currentIndex = index;

        // 1. Update Graphics
        graphicSlides.forEach((slide, i) => {
            if (i === currentIndex) {
                slide.classList.add('active');
            } else {
                slide.classList.remove('active');
            }
        });

        // 2. Update Text
        textSlides.forEach((slide, i) => {
            if (i === currentIndex) {
                slide.classList.add('active');
            } else {
                slide.classList.remove('active');
            }
        });

        // 3. Update Dots
        dots.forEach((dot, i) => {
            if (i === currentIndex) {
                dot.classList.add('active');
            } else {
                dot.classList.remove('active');
            }
        });
    }

    // Next Slide helper
    function nextSlide() {
        showSlide(currentIndex + 1);
    }

    // Start Auto-play
    function startInterval() {
        slideInterval = setInterval(nextSlide, intervalTime);
    }

    // Reset timer on interaction
    function resetInterval() {
        clearInterval(slideInterval);
        startInterval();
    }

    // Global function for onclick handlers in HTML
    window.goToSlide = function(index) {
        showSlide(index);
        resetInterval();
    };

    // Initialize
    startInterval();

    // Terms of Use Validation
    const btnCreate = document.getElementById('btn-create');
    const btnImport = document.getElementById('btn-import');
    const termsCheck = document.getElementById('terms-check');
    const termsWrapper = document.getElementById('terms-wrapper');

    function validateAndRedirect(url) {
        if (termsCheck && termsCheck.checked) {
            window.location.href = url;
        } else {
            // Shake animation
            if(termsWrapper) {
                termsWrapper.style.transition = 'transform 0.1s';
                termsWrapper.style.transform = 'translateX(5px)';
                setTimeout(() => {
                    termsWrapper.style.transform = 'translateX(-5px)';
                    setTimeout(() => {
                        termsWrapper.style.transform = 'translateX(0)';
                    }, 100);
                }, 100);
                
                // Highlight text
                const label = termsWrapper.querySelector('.legal-label');
                if(label) {
                    const originalColor = label.style.color;
                    label.style.color = '#ef4444'; // Red
                    setTimeout(() => {
                        label.style.color = originalColor;
                    }, 1000);
                }
            }
        }
    }

    if(btnCreate) {
        btnCreate.addEventListener('click', (e) => {
            e.preventDefault();
            validateAndRedirect('user/generate-wallet.html');
        });
    }

    if(btnImport) {
        btnImport.addEventListener('click', (e) => {
            e.preventDefault();
            validateAndRedirect('user/import-wallet.html');
        });
    }
});
