<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wallet Dashboard</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'app-bg': '#0d0d0d',
                        'card-bg': '#151617',
                        'border-color': '#222425',
                        'text-primary': '#ffffff',
                        'text-secondary': '#9ca3af',
                        'accent': '#7c3aed',
                        'danger': '#f87171'
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        /* Custom scrollbar for better aesthetics */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: #0d0d0d; }
        ::-webkit-scrollbar-thumb { background: #222425; border-radius: 3px; }
        ::-webkit-scrollbar-thumb:hover { background: #333; }
    </style>
</head>
<body class="bg-app-bg text-text-primary h-screen flex flex-col overflow-hidden selection:bg-accent selection:text-white">
    
    <!-- Top Navigation Bar -->
    <header class="flex justify-between items-center px-4 py-3 border-b border-border-color sticky top-0 bg-app-bg/95 backdrop-blur-sm z-20">
        <div class="flex items-center gap-3">
            <!-- Avatar Placeholder -->
            <div class="w-8 h-8 rounded-full bg-gradient-to-br from-yellow-400 to-purple-600 ring-2 ring-app-bg cursor-pointer"></div>
            <div class="cursor-pointer">
                <div class="font-bold text-sm leading-tight">Account 1</div>
                <div class="text-[11px] text-text-secondary font-medium tracking-wide">0x1234...5678</div>
            </div>
        </div>
        <div class="flex items-center gap-5">
             <!-- Notification/Scan Icons -->
             <button class="text-text-secondary hover:text-white transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
             </button>
             <button class="text-text-secondary hover:text-white transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7"></path>
                </svg>
             </button>
        </div>
    </header>

    <!-- Main Content -->
    <main class="flex-1 overflow-y-auto pb-24">
        
        <!-- Hero Section: Balance -->
        <section class="text-center pt-8 pb-6 px-4">
            <h1 class="text-[44px] font-extrabold tracking-tight leading-none mb-2 text-white">$0.00</h1>
            <div class="flex items-center justify-center gap-2">
                <span class="bg-[#1b0f0f] border border-[#3a1f1f] text-danger text-xs font-semibold px-2 py-1 rounded-lg flex items-center">
                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path>
                    </svg>
                    0.00%
                </span>
            </div>
        </section>

        <!-- Action Buttons Grid -->
        <section class="grid grid-cols-4 gap-3 px-5 mb-8">
            <button class="flex flex-col items-center gap-2 group">
                <div class="w-12 h-12 rounded-full bg-card-bg border border-border-color flex items-center justify-center text-accent group-hover:border-accent group-hover:bg-accent/10 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
                    </svg>
                </div>
                <span class="text-xs font-medium text-text-secondary group-hover:text-white transition-colors">Send</span>
            </button>
             <button class="flex flex-col items-center gap-2 group">
                <div class="w-12 h-12 rounded-full bg-card-bg border border-border-color flex items-center justify-center text-accent group-hover:border-accent group-hover:bg-accent/10 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path>
                    </svg>
                </div>
                <span class="text-xs font-medium text-text-secondary group-hover:text-white transition-colors">Receive</span>
            </button>
             <button class="flex flex-col items-center gap-2 group">
                <div class="w-12 h-12 rounded-full bg-card-bg border border-border-color flex items-center justify-center text-accent group-hover:border-accent group-hover:bg-accent/10 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <span class="text-xs font-medium text-text-secondary group-hover:text-white transition-colors">Buy</span>
            </button>
             <button class="flex flex-col items-center gap-2 group">
                <div class="w-12 h-12 rounded-full bg-card-bg border border-border-color flex items-center justify-center text-accent group-hover:border-accent group-hover:bg-accent/10 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                    </svg>
                </div>
                <span class="text-xs font-medium text-text-secondary group-hover:text-white transition-colors">Swap</span>
            </button>
        </section>

        <!-- Tabs Navigation -->
        <div class="flex items-center gap-8 px-5 border-b border-border-color mb-4">
            <button class="py-3 text-sm font-bold border-b-2 border-white text-white">Tokens</button>
            <button class="py-3 text-sm font-bold border-b-2 border-transparent text-text-secondary hover:text-white transition-colors">NFTs</button>
            <button class="py-3 text-sm font-bold border-b-2 border-transparent text-text-secondary hover:text-white transition-colors">Activity</button>
        </div>

        <!-- Token List -->
        <div class="px-4 space-y-3">
            <!-- Bitcoin -->
            <div class="flex items-center justify-between py-3 px-3 rounded-xl hover:bg-card-bg transition-colors cursor-pointer group">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-orange-500 flex items-center justify-center text-white shadow-lg">
                        <svg class="w-6 h-6" viewBox="0 0 32 32" fill="currentColor"><path d="M23.94 17.58c.84-2.28.32-4.14-1.74-5.12 1.42-.98 2.1-3.24 1.14-5.6-1.54-3.78-5.34-4.66-10.46-3.86L12 1.18l-1.9.48.9 3.6c-.5.12-1 .26-1.5.4l-.9-3.6-1.9.48.88 3.52c-.4.1-3.18.8-3.18.8l-.64 2.58s1.76.4 1.72.42c.96.24 1.14.88 1.1 1.4l-1.1 4.4c.06.02.14.04.22.08l-.22-.06-1.54 6.16c-.12.28-.42.72-1.1.54.04.06-1.72-.42-1.72-.42l-1.2 2.76 3 .76c.56.14 1.1.28 1.66.4l-.92 3.66 1.92.48.9-3.64c.52.14 1.02.26 1.52.38l-.88 3.64 1.9.48.92-3.64c3.56.68 6.24.4 7.36-2.82zm-4.34-6.84c.66 2.66-3.86 2.82-5.32 2.82l.96-3.84c1.46-.36 6.06-1.14 4.36 1.02zm.58 6.64c.76 3.06-4.96 3.02-6.34 3.02l1.04-4.16c1.38.02 6.84-.4 5.3 1.14z"></path></svg>
                    </div>
                    <div>
                        <div class="font-bold text-[15px] group-hover:text-accent transition-colors">Bitcoin</div>
                        <div class="text-xs text-text-secondary">0 BTC</div>
                    </div>
                </div>
                <div class="text-right">
                    <div class="font-bold text-[15px]">$0.00</div>
                    <div class="text-xs text-text-secondary">0%</div>
                </div>
            </div>

             <!-- Ethereum -->
            <div class="flex items-center justify-between py-3 px-3 rounded-xl hover:bg-card-bg transition-colors cursor-pointer group">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-white shadow-lg">
                        <svg class="w-5 h-5" viewBox="0 0 32 32" fill="currentColor"><path d="M15.92 1.34l-.32.36v20.4l.32.1.16-.16 9.24-5.46L16 1.34zm.16 23.4l-.16.1v8.82l.16.46 9.26-13.04-9.26 3.66zm-1.6-23.4L5.18 16.58l9.14 5.46V1.7l-.32-.36zm0 23.4l-9.26-3.66 9.26 13.04V24.74z"></path></svg>
                    </div>
                    <div>
                        <div class="font-bold text-[15px] group-hover:text-accent transition-colors">Ethereum</div>
                        <div class="text-xs text-text-secondary">0 ETH</div>
                    </div>
                </div>
                <div class="text-right">
                    <div class="font-bold text-[15px]">$0.00</div>
                    <div class="text-xs text-text-secondary">0%</div>
                </div>
            </div>

            <!-- More placeholders can be added here -->
            <div class="text-center pt-4 pb-8">
                 <p class="text-text-secondary text-xs">Don't see your token? <a href="#" class="text-accent hover:underline">Import</a></p>
            </div>
        </div>
    </main>

    <!-- Bottom Navigation Bar -->
    <nav class="fixed bottom-0 left-0 right-0 bg-app-bg border-t border-border-color flex justify-around items-center py-3 pb-5 z-20">
        <button class="text-accent flex flex-col items-center gap-1 w-16">
            <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"></path>
            </svg>
        </button>
        <button class="text-text-secondary hover:text-white flex flex-col items-center gap-1 w-16 transition-colors">
             <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
             </svg>
        </button>
        <button class="text-text-secondary hover:text-white flex flex-col items-center gap-1 w-16 transition-colors">
             <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
             </svg>
        </button>
         <button class="text-text-secondary hover:text-white flex flex-col items-center gap-1 w-16 transition-colors">
             <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
             </svg>
        </button>
    </nav>
</body>
</html>
