// multi-chain-config.js
// Curated list of reliable, free public RPC endpoints and API configurations.
// NOTE: For production, replace API keys with your own (e.g., Infura, Alchemy, Blockfrost).

const CONFIG = {
    // Environment
    ENV: 'production', // or 'development'

    // Chain Definitions
    CHAINS: {
        // --- EVM CHAINS ---
        ethereum: {
            name: 'Ethereum',
            type: 'evm',
            chainId: 1,
            nativeCurrency: { name: 'Ether', symbol: 'ETH', decimals: 18 },
            rpcs: [
                'https://eth.llamarpc.com',
                'https://ethereum.publicnode.com',
                'https://rpc.ankr.com/eth',
                'https://1rpc.io/eth',
                'https://rpc.flashbots.net',
                'https://cloudflare-eth.com'
            ],
            explorer: 'https://etherscan.io'
        },
        bsc: {
            name: 'BNB Smart Chain',
            type: 'evm',
            chainId: 56,
            nativeCurrency: { name: 'BNB', symbol: 'BNB', decimals: 18 },
            rpcs: [
                'https://bsc-dataseed1.binance.org',
                'https://bsc-dataseed2.binance.org',
                'https://bsc-dataseed.binance.org',
                'https://rpc.ankr.com/bsc',
                'https://1rpc.io/bnb',
                'https://binance.llamarpc.com'
            ],
            explorer: 'https://bscscan.com'
        },
        polygon: {
            name: 'Polygon',
            type: 'evm',
            chainId: 137,
            nativeCurrency: { name: 'MATIC', symbol: 'MATIC', decimals: 18 },
            rpcs: [
                'https://polygon.llamarpc.com',
                'https://polygon-rpc.com',
                'https://rpc.ankr.com/polygon',
                'https://1rpc.io/matic',
                'https://rpc-mainnet.maticvigil.com'
            ],
            explorer: 'https://polygonscan.com'
        },

        // --- NON-EVM CHAINS ---
        solana: {
            name: 'Solana',
            type: 'solana',
            nativeCurrency: { name: 'Solana', symbol: 'SOL', decimals: 9 },
            rpcs: [
                'https://api.mainnet-beta.solana.com',
                'https://solana.public-rpc.com',
                'https://rpc.ankr.com/solana',
                'https://solana-api.projectserum.com'
            ],
            explorer: 'https://solscan.io'
        },
        bitcoin: {
            name: 'Bitcoin',
            type: 'bitcoin',
            nativeCurrency: { name: 'Bitcoin', symbol: 'BTC', decimals: 8 },
            // Bitcoin public endpoints are usually REST APIs, not JSON-RPC
            rpcs: [
                'https://mempool.space/api',
                'https://blockstream.info/api'
            ],
            explorer: 'https://mempool.space'
        },
        cardano: {
            name: 'Cardano',
            type: 'cardano',
            nativeCurrency: { name: 'ADA', symbol: 'ADA', decimals: 6 },
            rpcs: [
                'https://api.koios.rest/api/v0' // Free tier public API
            ],
            explorer: 'https://cardanoscan.io'
        },
        cosmos: {
            name: 'Cosmos Hub',
            type: 'cosmos',
            nativeCurrency: { name: 'ATOM', symbol: 'ATOM', decimals: 6 },
            rpcs: [
                'https://rpc.cosmos.network',
                'https://rpc.ankr.com/cosmos',
                'https://cosmos-rpc.polkachu.com'
            ],
            explorer: 'https://www.mintscan.io/cosmos'
        }
    },

    // Snaps Configuration (IDs for MetaMask Snaps)
    SNAPS: {
        bitcoin: 'npm:@shapeshift/bitcoin-snap', // Example ID
        solana: 'npm:@solana/wallet-adapter-wallets' // Conceptual, usually handled via adapter
    }
};

// Export for module usage if needed, or global
if (typeof module !== 'undefined') module.exports = CONFIG;
